//
//  CheckPleaseViewController.m
//  CheckPlease
//
//  Created by Robert Górczyński on 11-07-26.
//

#import "CheckPleaseViewController.h"
#import "CheckMarkRecognizer.h" 

@implementation CheckPleaseViewController
@synthesize label; 

- (void)doCheck:(CheckMarkRecognizer *)check { 
    label.text = @"✓"; 
    [self performSelector:@selector(eraseLabel) 
               withObject:nil afterDelay:1.6];     
} 

- (void)eraseLabel { 
    label.text = @""; 
}

// Implementacja metody viewDidLoad pozwala na przeprowadzenie konfiguracji po wczytaniu widoku, zazwyczaj z pliku nib.
- (void)viewDidLoad {
    [super viewDidLoad];
    CheckMarkRecognizer *check = [[[CheckMarkRecognizer alloc] initWithTarget:self 
																	   action:@selector(doCheck:)] autorelease]; 
    [self.view addGestureRecognizer:check]; 	
}

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
    self.label = nil; 
    [super viewDidUnload]; 
}


- (void)dealloc {
    [label release]; 
    [super dealloc];
}

@end
